<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_DataWriter_Log extends XenForo_DataWriter
{

    protected function _getFields()
    {
        return array(
            'xf_sonnb_stop_spam_log' => array(
                'id' => array(
                    'type' => self::TYPE_UINT, 
                    'autoIncrement' => true
                ),
                'username' => array(
                    'type' => self::TYPE_STRING, 
                    'maxLength' => 50, 
                    'default' => ''
                ),
                'email' => array(
                    'type' => self::TYPE_STRING, 
                    'maxLength' => 100, 
                    'default' => ''
                ),
                'ip' => array(
                    'type' => self::TYPE_STRING, 
                    'maxLength' => 15, 
                    'default' => 0
                ),
                'user_id' => array(
                    'type' => self::TYPE_UINT,
                    'default' => 0
                ),
                'time' => array(
                    'type' => self::TYPE_UINT, 
                    'default' => XenForo_Application::$time
                ),
                'content_type' => array(
                    'type' => self::TYPE_STRING,
                    'required' => true, 
                    'default' => 'register',
                    'allowedValues' => array('register','conversation_reply','conversation','comment','profile','post','thread', 'personal_detail','signature')
                ),
                'log_type' => array(
                    'type' => self::TYPE_STRING,
                    'required' => true, 
                    'default' => 'register',
                    'allowedValues' => array('link','keyword','akismet','register')
                ),
                'content_id' => array(
                    'type' => self::TYPE_UINT
                ),
                'data' => array(
                    'type' => self::TYPE_SERIALIZED, 
                    'default' => ''
                ),
                'action' => array(
                    'type' => self::TYPE_STRING, 
                    'required' => true, 
                    'default' => 'allow',
                    'allowedValues' => array('block','pc','report','discouraged','moderate','allow')
                )
        ));
    }

    protected function _getExistingData($data)
    {
        if (!$id = $this->_getExistingPrimaryKey($data, 'id'))
        {
            return false;
        }

        return array('xf_sonnb_stop_spam_log' => $this->_getLogModel()->getLog($id));
    }

    protected function _getUpdateCondition($tableName)
    {
        return 'id = ' . $this->_db->quote($this->getExisting('id'));
    }

    protected function _getLogModel()
    {
        return $this->getModelFromCache('sonnbStopSpamHere_Model_Log');
    }

}

?>
